/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class LogoAddressBook {
    private static LogoAddressBook fSingletonInstance = null;
    protected static final String ADDRESS_BOOK_FILE_NAME = "AddressBook.txt";
    private Properties fProperties = null;
    private String[] fColumnRequired = null;
    private String fFileName = this.getUserAddressBookFileName();
    private static final String PREFIX = "Cell_";
    private static final int NO_SELECTION = -1;
    protected String[][] fAddressData = null;

    public String[][] getData() {
        if (this.fAddressData == null && this.fProperties != null) {
            int rowCount = this.getAddressBookRowCount();
            this.fAddressData = new String[rowCount][this.fColumnRequired.length];
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < this.fColumnRequired.length; ++j) {
                    this.fAddressData[i][j] = this.fProperties.getProperty(this.cell(i, this.getAddressBookColumnIndex(j)), "");
                }
            }
        }
        return this.fAddressData;
    }

    private void fireDataDirtyEvent() {
        this.fAddressData = null;
    }

    public boolean setSelectedIndex(int rowIndex) {
        if (rowIndex >= -1 && rowIndex < this.getAddressBookRowCount()) {
            if (this.fProperties != null) {
                this.fProperties.setProperty("selectedRow", new Integer(rowIndex).toString());
                return true;
            }
            return false;
        }
        return false;
    }

    public int getSelectedIndex() {
        int ret = -1;
        try {
            ret = Integer.valueOf(this.fProperties.getProperty("selectedRow", "-1"));
            if (ret >= this.getAddressBookRowCount() || ret < -1) {
                ret = -1;
                this.setSelectedIndex(-1);
            }
            return ret;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String[] getSelectRowData() {
        String[] selectedRowData = new String[this.fColumnRequired.length + 1];
        int row = this.getSelectedIndex();
        selectedRowData[0] = new Integer(row).toString();
        if (this.fProperties != null) {
            for (int j = 0; j < this.fColumnRequired.length; ++j) {
                selectedRowData[j + 1] = this.fProperties.getProperty(this.cell(row, this.getAddressBookColumnIndex(j)), "");
            }
        }
        return selectedRowData;
    }

    public boolean addNewRow(String[] newRow) {
        int rowCount = this.getAddressBookRowCount();
        String cellString = null;
        if (this.fProperties != null) {
            for (int j = 0; j < this.fColumnRequired.length; ++j) {
                cellString = j < newRow.length ? newRow[j] : "";
                this.fProperties.setProperty(this.cell(rowCount, this.getAddressBookColumnIndex(j)), cellString);
            }
            this.fProperties.setProperty("rowCount", new Integer(rowCount + 1).toString());
            this.fireDataDirtyEvent();
            return true;
        }
        return false;
    }

    public boolean removeRow(int rowIndex) {
        int rowCount = this.getAddressBookRowCount();
        if (rowIndex >= 0 && rowIndex < rowCount) {
            if (this.fProperties != null) {
                for (int j = 0; j < this.getAddressBookHead().size(); ++j) {
                    this.fProperties.setProperty(this.cell(rowIndex, j), this.fProperties.getProperty(this.cell(rowCount - 1, j), ""));
                    this.fProperties.setProperty(this.cell(rowCount - 1, j), "");
                }
                this.fProperties.setProperty("rowCount", new Integer(rowCount - 1).toString());
                if (this.getSelectedIndex() == rowCount - 1) {
                    this.setSelectedIndex(-1);
                }
                this.fireDataDirtyEvent();
                return true;
            }
            return false;
        }
        return false;
    }

    public String getCellContent(int rowIndex, int columnIndex) {
        try {
            return this.fProperties.getProperty(this.cell(rowIndex, this.getAddressBookColumnIndex(columnIndex)), "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean updateCell(int rowIndex, int columnIndex) {
        try {
            String cellName;
            String pre;
            if (rowIndex >= 0 && rowIndex < this.getAddressBookRowCount() && columnIndex >= 0 && columnIndex < this.fColumnRequired.length && !this.fAddressData[rowIndex][columnIndex].equals(pre = this.fProperties.getProperty(cellName = this.cell(rowIndex, this.getAddressBookColumnIndex(columnIndex)), ""))) {
                this.fProperties.setProperty(cellName, this.fAddressData[rowIndex][columnIndex]);
                System.out.print("Cell updated: \npre: " + pre + "\nNew: " + this.fAddressData[rowIndex][columnIndex]);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean setColumnHeadNames(String[] ColumnHeadName) {
        try {
            this.fColumnRequired = ColumnHeadName;
            for (int i = 0; i < this.fColumnRequired.length; ++i) {
                if (this.getAddressBookColumnIndex(i) != -1) continue;
                this.addColumnToAddressBook(this.fColumnRequired[i]);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getAddressBookColumnIndex(int requiredIndex) {
        Vector columnsExisted = this.getAddressBookHead();
        if (columnsExisted != null) {
            for (int j = 0; j < columnsExisted.size(); ++j) {
                if (!this.fColumnRequired[requiredIndex].equals((String)columnsExisted.elementAt(j))) continue;
                return j;
            }
        }
        return -1;
    }

    private void addColumnToAddressBook(String column) {
        if (this.fProperties != null) {
            String pre_property = null;
            pre_property = this.fProperties.getProperty("head");
            this.fProperties.setProperty("head", this.getNewString(pre_property, "\"" + column + "\""));
        }
    }

    private String getNewString(String preString, String appendix) {
        boolean emptyMark = false;
        if (preString == null) {
            emptyMark = true;
        } else if (preString.length() == 0) {
            emptyMark = true;
        }
        if (emptyMark) {
            return appendix;
        }
        return preString + ", " + appendix;
    }

    public void saveAddressBook() {
        File addressBookFile = new File(this.fFileName);
        if (addressBookFile != null) {
            try {
                if (!addressBookFile.getAbsoluteFile().getParentFile().exists()) {
                    addressBookFile.getAbsoluteFile().getParentFile().mkdirs();
                }
                FileOutputStream appStream = new FileOutputStream(addressBookFile);
                this.fProperties.store(appStream, Application.getName() + " addressBook");
                appStream.close();
            }
            catch (IOException e) {
                Log.println("log.err.writeProtected.addressBookFile", "To store your settings the file '" + addressBookFile + "' must be writetable");
                if (this.fFileName.endsWith(".tmp")) {
                    System.out.println("Can not save address book file.");
                }
                this.fFileName = this.fFileName.replace(".txt", ".tmp");
                this.saveAddressBook();
            }
        }
    }

    private Vector getAddressBookHead() {
        if (this.fProperties != null) {
            String head = this.fProperties.getProperty("head");
            return this.getSubStrings(head);
        }
        return null;
    }

    private int getAddressBookRowCount() {
        try {
            return Integer.valueOf(this.fProperties.getProperty("rowCount"));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Vector getSubStrings(String supString) {
        if (supString == null) {
            return null;
        }
        Vector<String> strings = new Vector<String>();
        int ch = 34;
        boolean isStart = true;
        int startIndex = 0;
        int endIndex = 0;
        int i = 0;
        while ((i = supString.indexOf(34, i)) != -1) {
            if (isStart) {
                startIndex = i;
                isStart = false;
            } else {
                endIndex = i;
                strings.add(supString.substring(startIndex + 1, endIndex));
                isStart = true;
            }
            ++i;
        }
        return strings;
    }

    public static LogoAddressBook instance(String[] columnHeadName) {
        if (fSingletonInstance == null) {
            if (columnHeadName == null) {
                return null;
            }
            fSingletonInstance = new LogoAddressBook();
            fSingletonInstance.setColumnHeadNames(columnHeadName);
        }
        return fSingletonInstance;
    }

    public static void close() {
        fSingletonInstance = null;
    }

    private LogoAddressBook() {
        if (!this.loadAddressBook(this.fFileName)) {
            System.out.println("No properties found!");
            this.createEmptyAddressBook();
        }
    }

    public LogoAddressBook refrshAddressBook() {
        this.loadAddressBook(this.fFileName);
        return this;
    }

    private void createEmptyAddressBook() {
        this.fProperties = new Properties();
        this.fProperties.setProperty("rowCount", "0");
        this.fProperties.setProperty("head", "");
    }

    protected String getUserAddressBookFileName() {
        Version v = Version.getCurrentVersion();
        return System.getProperty("user.home", "") + "/." + v.getApplicationFileName() + v.getMajorVersion() + "." + v.getMinorVersion() + "/" + ADDRESS_BOOK_FILE_NAME;
    }

    protected boolean loadAddressBook(String propertyFile) {
        try {
            this.fProperties = new Properties();
            FileInputStream appStream = new FileInputStream(propertyFile);
            this.fProperties.load(appStream);
            appStream.close();
            return true;
        }
        catch (IOException ioe) {
            this.fProperties = null;
            System.out.println("loading " + propertyFile + " failed");
            return false;
        }
    }

    private String cell(int rowIndex, int columnIndex) {
        return PREFIX + rowIndex + "_" + columnIndex;
    }
}

